/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.light;

import cofh.core.network.PacketBase;
import cofh.core.network.PacketHandler;
import cofh.core.util.ChunkCoord;
import cofh.thermaldynamics.duct.light.DuctUnitLight;
import cofh.thermaldynamics.duct.light.PacketLight;
import cofh.thermaldynamics.multiblock.IGridTile;
import cofh.thermaldynamics.multiblock.MultiBlockGrid;
import cofh.thermaldynamics.util.WorldGridList;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.server.management.PlayerChunkMap;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class GridLight
extends MultiBlockGrid<DuctUnitLight> {
    public HashSet<ChunkCoord> chunks;
    public boolean upToDate = false;
    boolean lit = false;

    public GridLight(WorldGridList worldGrid) {
        super(worldGrid);
    }

    public GridLight(World worldObj) {
        super(worldObj);
    }

    @Override
    public boolean canAddBlock(IGridTile aBlock) {
        return aBlock instanceof DuctUnitLight;
    }

    @Override
    public void onMajorGridChange() {
        super.onMajorGridChange();
        this.upToDate = false;
        this.chunks = null;
    }

    @Override
    public void onMinorGridChange() {
        super.onMinorGridChange();
        this.upToDate = false;
    }

    @Override
    public void tickGrid() {
        boolean shouldBeLit;
        super.tickGrid();
        MultiBlockGrid.RedstoneControl rs = null;
        if (this.upToDate && this.worldGrid.worldObj.func_82737_E() % 160L != 0L) {
            if (rs != null) {
                for (int i = 0; i < 16; ++i) {
                    if (rs.nextRedstoneLevel[i] == -128) continue;
                    this.upToDate = false;
                }
            }
            return;
        }
        if (rs != null) {
            for (int i = 0; i < 16; ++i) {
                if (rs.nextRedstoneLevel[i] != -128) continue;
                this.upToDate = false;
            }
        } else {
            this.upToDate = true;
        }
        if (!(shouldBeLit = rs != null ? rs.shouldEmitLight() : false)) {
            for (Object object : Iterables.concat((Iterable)this.nodeSet, (Iterable)this.idleSet)) {
                DuctUnitLight lamp = (DuctUnitLight)object;
                if (!lamp.lit) continue;
                shouldBeLit = true;
                break;
            }
        }
        if (this.lit != shouldBeLit) {
            this.setLight(shouldBeLit);
        }
    }

    public void setLight(boolean lit) {
        this.lit = lit;
        if (this.chunks == null) {
            this.buildMap();
        }
        if (this.worldGrid.worldObj instanceof WorldServer) {
            PacketLight packet = new PacketLight(lit, this);
            WorldServer dimension = (WorldServer)this.worldGrid.worldObj;
            PlayerChunkMap manger = dimension.func_184164_w();
            block0: for (EntityPlayer player : dimension.field_73010_i) {
                for (ChunkCoord chunk : this.chunks) {
                    PlayerChunkMapEntry inst = manger.func_187301_b(chunk.chunkX, chunk.chunkZ);
                    if (inst == null || !inst.func_187275_d((EntityPlayerMP)player)) continue;
                    PacketHandler.sendTo((PacketBase)packet, (EntityPlayer)player);
                    continue block0;
                }
            }
            for (DuctUnitLight block : Iterables.concat((Iterable)this.nodeSet, (Iterable)this.idleSet)) {
                block.checkLight();
            }
        }
    }

    public void buildMap() {
        this.chunks = new HashSet();
        for (DuctUnitLight iGridTile : Iterables.concat((Iterable)this.nodeSet, (Iterable)this.idleSet)) {
            this.buildMapEntry(iGridTile);
        }
    }

    private void buildMapEntry(DuctUnitLight iGridTile) {
        this.chunks.add(new ChunkCoord(iGridTile.x() >> 4, iGridTile.z() >> 4));
    }
}

